Scriptname RF:TutorialQuest Extends Quest

RF:FuelHandlerQuest Property RFQ Auto Mandatory Const

Message Property OutOfFuelMessage Mandatory Const Auto

Quest Property MQ101 Mandatory Const Auto

SpaceshipReference MyShip
Actor PlayerRef

Event OnQuestInit()
    StartTimer(3)
EndEvent

Event OnTimer(int aiTimerID)
    PlayerREf = Game.GetPlayeR()
    RegisterForRemoteEvent(MQ101, "OnStageSet")
EndEvent

Event Quest.OnStageSet(Quest akSender, int auiStageID, int auiItemID)
    if akSender == MQ101
        If auiStageID == 500 ; Fleet encounter over
            MyShip = RFQ.GetShip()
            RFQ.GetFuelLevel()
            MyShip.AddItem(RFQ.FuelTanks[0], 4, true)
            RFQ.Realfuel(true)
        ElseIf auiStageID == 605 ; Got to Kreet
            RFQ.Realfuel(true)
        ElseIf auiStageID == 1800 || auiStageID == 2100 ; Quest complete
            UnRegisterForRemoteEvent(MQ101, "OnStageSet")
        EndIf
    EndIF
EndEvent
